<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Module Name: FaceLogin
 * Description: Login with Face Recognition for Perfex CRM.
 * Version: 1.0.0
 * Requires at least: 3.0.*
 * Author: Hopperstack
 * Author URI: https://codecanyon.net/user/hopperstack
 */

define('FACELOGIN_MODULE_NAME', 'facelogin');
define('VERSION_FACELOGIN', 100);
define('FACELOGIN_MODULE_ITEM_ID', 'FaceLogin');
define('FACELOGIN_JSONSAVE_FOLDER', module_dir_path(FACELOGIN_MODULE_NAME, 'faces'));


hooks()->add_action('admin_init', 'facelogin_init_menu_items');

// Register language files
register_language_files(FACELOGIN_MODULE_NAME, [FACELOGIN_MODULE_NAME]);

/**
 * Module activation hook.
 */
register_activation_hook(FACELOGIN_MODULE_NAME, 'facelogin_activate_module');

function facelogin_activate_module()
{
    require_once __DIR__ . '/install.php';
}


$CI = &get_instance();
// Load helper functions
$CI->load->helper(FACELOGIN_MODULE_NAME . '/facelogin');


function facelogin_init_menu_items(){
    
    $CI = &get_instance();

    if (get_option('facelogin_is_active') == 1 && get_option('facelogin_purchase_is_valid') == 1) {
        $CI->app_menu->add_sidebar_menu_item(FACELOGIN_MODULE_NAME, [
            'name'     => _l('facelogin'),
            'icon'     => 'fa fa-right-to-bracket',
            'href'     => admin_url('facelogin/setup'),
            'position' => 30,
        ]);
    }
    if (is_admin()) {
        $CI->app_menu->add_setup_menu_item(FACELOGIN_MODULE_NAME, [
            'slug'     => 'facelogin_setting',
            'name'     => _l('facelogin_setting'),
            'href'     => admin_url('facelogin/setting'),
            'position' => 35,
        ]);
    }
}


hooks()->add_action('before_admin_login_form_close', 'facelogin_init_login_btn');
function facelogin_init_login_btn()
{
    if (get_option('facelogin_is_active') == 1 && get_option('facelogin_purchase_is_valid') == 1) {
        include __DIR__ . '/views/login_btn.php';
    }
}
